<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <title></title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width">

        <!-- Place favicon.ico and apple-touch-icon.png in the root directory -->

        <link rel="stylesheet" href="css/normalize.css">
        <link rel="stylesheet" href="css/bootstrap.min.css">
        <link rel="stylesheet" href="css/bootstrap-responsive.min.css">
        <link rel="stylesheet" href="css/main.css">
        <script src="js/vendor/modernizr-2.6.2.min.js"></script>
    </head>
    <style type="text/css">
    .underline
    {
        text-decoration: underline;
    }

    .push
    {
        margin-top:10px;
        margin-bottom:10px;
        height:1px;
        width:100%;
    }

    </style>
    <body>
        <div class="row-fluid">
            <div class="container-fluid">
                <h1>Welcome to the tutorial page</h1>
                <p>
                    Please use this page as a guide line for managing the content and the structure
                    of the site.
                </p>

                <h2>Table of contents</h2>
                <ul class="inline-block">
                    <li><a href='#filestructure'>File Structure</a></li>
                    <li><a href='#navigationhelp'>Navigation</a></li>
                    <li><a href="#pagehelp">Pages</a></li>
                    <li><a href="#layerhelp">Layers</a></li>
                </ul>

                <div class="push"></div>

                <!-- content -->
                <div id="filestructure">
                    <h1 class="underline">File Structure</h1>

                    <dl class="dl-horizontal">
                        <dt>css folder</dt>
                        <dd>
                            where all the styles for the pages, layers are kept. 
                            You don’t really have to go into this page to add content, 
                            however if you felt like changing some colours, or some sizes, 
                            you can go into this folder and tweak a file called <span class="label label-inverse">‘main.css’</span>
                        </dd>

                        <dt>img folder</dt>
                        <dd>
                            holds all the images you see on the page, 
                            the layers and background pictures are all kept in this folder, 
                            and the images for the plants are kept in the plants folder. 
                            If you decide to add another plant  add the image into this folder.
                        </dd>

                        <dt>views folder</dt>
                        <dd>
                            This is where all the content is managed and edited. 
                            This folder holds the main files needed for the site:
                                <dl class="dl-horizontal">
                                    <dt>navigation folder</dt>
                                    <dd>
                                        holds a file called <span class="label label-inverse">navigation.php</span> where you can change the amount of navigation 
                                        buttons and the names of the menu’s. 
                                        <a href="#navigationhelp">Click here to learn more about editing the navigation.php file.</a>
                                    </dd>

                                    <dt>pages folder</dt>
                                    <dd>
                                        holds all the pages you see appear when clicking on the navigation buttons. 
                                        <a href="#pagehelp">Click here to learn more about editing the content you see from each navigation.</a>
                                    </dd>

                                    <dt>controller.php</dt>
                                    <dd>
                                        this page holds the layers and also the pages.
                                    </dd>

                                    <dt>layerstructure.php</dt>
                                    <dd>
                                        this page holds all the layers which are holding the plants and allowing the parallax to work, 
                                        this is where you can change what plants are being shown, 
                                        and what content for the plants, and also change how many layers, 
                                        and what background the layer shows. 
                                        <a href="#layerhelp">Click here to learn more about layers.</a>
                                    </dd>

                                    <dt>pagestructure.php</dt>
                                    <dd>
                                        this page holds the pages holding the content, 
                                        you only need to edit this file when adding a new page. 
                                        <a href="#pagehelp">Click here to learn more about pages.</a>
                                    </dd>

                                </dl>

                        </dd>
                    </dl>
                </div>

                <hr>
                <div class="push"></div>

                <div id="navigationhelp">
                    <h1 class="underline">Navigation</h1>
                    <p>
                        This page is in charge of the blue navigation.
                        You can change the navigation names on this page, and also which pages they show up.<br/>

                        This code here : <br/>
                        <pre>
                            &lt;li class="span3"&gt3;
                            &lt;a id="home-nav" href='#home'>Situs Herbalis &lt;/a&gt;
                            &lt;/li&gt;
                        </pre>

                        <br/>
                        The <stong>id</strong> tag is used to match the page, and must end start with the id tag of the page and end with a 
                        <span class="label label-important">‘-nav’.</span>
                        The href tag is used to also match to the page, however it must be identical to id tag of the page and start with a 
                        <span class="label label-important">‘#’</span><br/>
                        The middle section ‘Situs Herbalis’ is the name of the menu.
                        <span class="label label-important">Every new menu created must follow this structure.</span><br/>
                        
                        <div class="alert">
                            Note: the li tags which hold a class ‘span3’ is used to make sure that the navigations fit on 
                            the width of the screen provided, it is using a useful html framework called bootstrap 
                            <a href="http://twitter.github.com/bootstrap/" target="_blank">click here</a> to visit the website to 
                            get more information on how it works.
                            But to keep things simple the span classes work in additions of twelve, you will notice that the 
                            code uses ‘span3’ and only has 4 li tags to create 4 blue navigation buttons, if you where to add 
                            another navigation, you will need to change the number on the class to match an addition of twelve. 
                            By adding another li tag with the same class span3 you will end up with 5 navigation buttons which 
                            adds up to 15 and you will notice the fifth navigation jumps to the bottom because we are now greater 
                            than 12.
                        </div><br/>

                        To change the links to the right you only have to edit this section:
                        <pre>
                            &lt;div class="span3 copyright pull-right"&gt;
                                2013 © &lt;a href="http://www.ipeqi.com/" target="_blank"&gt;ipeqi&lt;/a&gt;
                                 & &lt;a href="http://www.karmava.com/" target="_blank"&gt;KarmaVA&lt;/a&gt;
                            &lt;/div&gt;

                        </pre>
                    </p>
                </div>
                
                <hr>
                <div class="push"></div>

                <div id="pagehelp">
                    <h1 class="underline">Pages</h1>
                    <p>
                        The file <span class="label label-inverse">‘pagestructure.php’</span> – 
                        holds all the pages, if a new page is created, 
                        you will need to add the page in this file in order for it to be seen.<br/>
                        The code looks like this:<br/>
                        <pre>
                            &lt;div class="row-fluid pages tab-content"&gt;
                                            &lt;?php include('views/pages/home.php'); ?&gt;
                                            &lt;?php include('views/pages/goodtoknow.php'); ?&gt;
                                            &lt;?php include('views/pages/goodtogo.php'); ?&gt;
                                            &lt;?php include('views/pages/googlemap.php'); ?&gt;
                            &lt;/div&gt;
                        </pre>

                        At the moment 4 pages are available, and all are added in this tag with the structure:<br/>
                        <code>&lt;?php include('views/pages/nameofpage.php'); ?&gt;</code><br/>
                        Simply copy that structure and change the ‘nameofpage’ to the new page you have created in the pages folder. 
                        Read on to find out about creating pages and making them work with the navigation.<br/>

                        <h3 class="underline">Individual Pages Structure</h3>
                        All pages have the same structure but different id tags.<br/>
                        At the moment there are four pages :<br/>
                        <div class="alert alert-info">
                            goodtogo.php, goodtoknow.php, googlemap.php, home.php
                        </div>
                        The pages all have the same html structure: <br/>
                        <pre>
                            &lt;div id="name-of-page" class="tab-pane page row-fluid box-radius20">
                                &lt;div class="content"&gt;
                                    &lt;div class="row-fluid"&gt;
                                        &lt;button class="close clearfix">&times;&lt;/button&gt;
                                    &lt;/div&gt;
                                    &lt;!-- insert content in this tag --&gt;
                                    &lt;div class="row-fluid"&gt;
                                        &lt;div class="span12"&gt;
                                            &lt;p&gt;
                                            Insert home content here
                                            &lt;/p&gt;
                                       &lt;/div&gt;
                                    &lt;/div&gt;
                                &lt;/div&gt;
                            &lt;/div&gt;&lt;!-- #name of page --&gt;
                        </pre><br/>
                        
                        Each page is constructed with an id and a set of classes:<br/>
                        <code>&lt;div id="name-of-page" class="tab-pane page row-fluid box-radius20"&gt;</code><br/>

                        To make a new page you simply copy the basic structure, and change the id tag to the 
                        name of the page or what name you decide to use, however if you make a new page you 
                        must make sure that there is also a navigation created in the <span class="label label-inverse">navigation.php</span> file.
                        <a href="#navigationhelp">Click here to read about navigation</a>.<br/><br/>
                        To change the content in the page you only need to change what is in the span12 tag, in this example:<br/>
                        <pre>
                            &lt;div class="row-fluid"&gt;
                                &lt;div class="span12"&gt;
                                    &lt;p&gt;
                                    Insert home content here
                                    &lt;/p&gt;
                                &lt;/div&gt;
                            &lt;/div&gt;
                        </pre>
                        <br/>

                        You can change what you see on the page by changing what is inside this tag:<br/>
                        <code>
                            &lt;p&gt;
                                Insert home content here
                            &lt;/p&gt;
                        </code>
                        You can also add whatever html you like in here, 
                        it is a good idea to read up on <a href="http://twitter.github.com/bootstrap/" target="_blank">bootstrap</a>, 
                        to help you build extra content on these pages and have it also show better on mobile.

                    </p>
                </div>

                <hr>
                <div class="push"></div>

                <div id="layerhelp">
                    <h1 class="underline">Layers</h1>
                    <p>
                        All layers are controlled by one file ‘layerstructure.php’, in the file you will notice that there are 
                        5 layers all commented with:<br/>
                        <code> &lt;!-- nth Layer --&gt; </code> nth stands for the order of the layer, 
                        the order of the layers determine which layer show’s in front or 
                        behind which layer.<br/>
                        Each layer is constructed with this :
                        <pre>
                            &lt;div class="span12 floater parallax-layer" style="width:2564px; bottom:0px; z-index:90;"&gt;
                                &lt;!-- layer background --&gt;
                                &lt;img class="floater" src="img/sky.png" border="0" style="top:0px;" /&gt;

                                &lt;!-- plants --&gt;
                                &lt;img data-toggle="popover" data-placement="right" data-content="This is the tree content" 
                                data-original-title="Beech Tree" class="plant floater" src="img/plants/beech_tree.png" 
                                border="0" style="bottom:277px; left:2%"/&gt;
                            &lt;/div>&lt;!-- .background-slider --&gt;
                        </pre><br/>
                        The first line:<br/>
                        <code>
                            &lt;div class="span12 floater parallax-layer" style="width:2564px; bottom:0px; z-index:90;"&gt;
                        </code><br/>
                        This starts the creation of the layer, all layers take the same class names, and styles, 
                        however the only thing that changes is the width of the layer, to make the parallax look good, 
                        if the layer is behind another layer that it must be at least wider than the layer in front, 
                        and vice versa for layers in front of other layers.<br/><br/>

                        With this line :<br/>
                        <code>
                            &lt;img class="floater" src="img/sky.png" border="0" style="top:0px;" /&gt;
                        </code><br/>

                        This is the background image for the layer, in this example it is the sky, 
                        when creating a new background image layer it must follow this structure, 
                        however you can alter the img tag to what image you would like when making a new layer.<br/><br/>

                        The next few lines :<br/>
                        <pre>
                        &lt;!-- plants --&gt;
                        &lt;img data-toggle="popover" data-placement="right" data-content="This is the tree content" 
                        data-original-title="Beech Tree" class="plant floater" src="img/plants/beech_tree.png" 
                        border="0" style="bottom:277px; left:2%"/&gt;
                        </pre><br/><br/>

                        This is a plant on the screen, it plant must follow the same structure and just like the layers, 
                        you can edit the image shown by altering the img tag’s src to what plant you are looking for 
                        <span class="label label-important">all plant images are kept in the plants folder ‘img/plants’</span>.<br/>
                        To change some settings for the plants such as the location of the pop up, 
                        the title of the pop up and content there are a 3 tags to look out for:<br/>

                        <dl class="dl-horizontal">
                            <dt>data-placement</dt>
                            <dd>change this to either top, right, left, bottom.</dd>
                            <dt>data-content</dt>
                            <dd>this is the actual text that appears in the pop up.</dd>
                            <dt>data-original-title</dt>
                            <dd>this is the title that shows up in the pop up.</dd>
                        </dl><br/>

                        To change the position of the plant you can edit the style tag: <br/>
                        <code>style="bottom:277px; left:2%"</code><br/>
                        make sure to use pixels for the bottom setting to keep them plants from floating in the air, 
                        and use percentages for moving the plant along horizontally to allow the plants to show 
                        identically on different sized screens.
                    </p>
                </div>


            </div><!-- .container-fluid -->
        </div><!-- .row-fluid -->
        <!-- Add your site or application content here -->
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.js"></script>
        <!--
        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js"></script>
        <script>window.jQuery || document.write('<script src="js/vendor/jquery-1.9.0.min.js"><\/script>')</script>
    -->
        <script src="js/bootstrap.min.js"></script>

        </script>
    </body>
</html>
