// jquery.events.frame.js (modernized for jQuery 3.x)
// Stephen Band (original), updated by ChatGPT

(function ($) {
    function FrameLoop(fn, duration) {
        var self = this, timer;
        this.frameDuration = duration || 25;
        this.frameCount = -1;

        function tick() {
            self.frameCount++;
            fn.call(self);
        }

        this.start = function () {
            tick();
            timer = setInterval(tick, this.frameDuration);
        };

        this.stop = function () {
            clearInterval(timer);
            timer = null;
        };
    }

    function triggerFrame() {
        var handler = $.event.special.frame.handler,
            e = $.Event("frame"),
            arr = this.array,
            len = arr.length;

        e.frameCount = this.frameCount;

        while (len--) {
            handler.call(arr[len], e);
        }
    }

    var loop;

    if (!$.event.special.frame) {
        $.event.special.frame = {
            setup: function (data) {
                if (loop) {
                    loop.array.push(this);
                } else {
                    loop = new FrameLoop(triggerFrame, data && data.frameDuration);
                    loop.array = [this];
                    setTimeout(function () {
                        loop.start();
                    }, 0);
                }
            },
            teardown: function () {
                var arr = loop.array,
                    i = arr.length;

                while (i--) {
                    if (arr[i] === this) {
                        arr.splice(i, 1);
                        break;
                    }
                }

                if (arr.length === 0) {
                    loop.stop();
                    loop = null;
                }
            },
            handler: function () {
                $.event.dispatch.apply(this, arguments);
            }
        };
    }
})(jQuery);
