;jQuery.noConflict();

//Variables
var window_width = -1; //Used to work out maximum width of page
var window_height = -1; //Used to work out maximum height of page
var page_padding = 10; //Padding around edges of page

var home = jQuery("#que");
/*var backgrounditems = jQuery("#que .background-image");
var maxbackgrounds = backgrounditems.length;
var navigationitems = jQuery(".navigation-item");*/

/* Elements */

jQuery(document).ready(function($)
{
	//Start script here
	//initNavigation($, navigationitems);
	//initBackground($, backgrounditems);

	$('#navigation-buttons li a').click(function (e) {
  		e.preventDefault();
  		$(this).tab('show');
	});
});

jQuery(window).load(function()
{
	var $ = jQuery;

	//Window Data
	window_width = $(window).width();
	window_height = $(window).height();
	padding = 10;
	$(home).data('loaded', false);
	ResizeAllPages($, ".main-page", -1, window_height, 0);
	ResizeAllPages($, ".parallax-layer", -1, window_height, 0);
	ResizeAllPages($, ".parallax-viewport", window_width, window_height, 0); 
	ResizeAllPages($, ".resizeheight", -1, window_height, 0);

	InitNavigation($);
	InitCloseButtons($, ".close");

	//Attach window resize functionality
	$(window).resize(function(){
		window_width = GetWindowWidth($);
		window_height = GetWindowHeight($);

		//Resize all pages
		ResizeAllPages($, ".main-page", -1, window_height, 0);
		ResizeAllPages($, ".parallax-layer", -1, window_height, 0);
		ResizeAllPages($, ".parallax-viewport", window_width, window_height, 0);
		ResizeAllPages($, ".resizeheight", -1, window_height, 0);

	});
});

/* extra functions */
function ResizeAllPages($, page, width, height, padding)
{
	//grabs the div tag page, and resizes it to what the window size is
	var pages = $(page);

	$.each(pages, function(index, value)
	{
		ResizePage($,$(value),width, height, padding);
	});
}

function InitNavigation($)
{
	//Find navigation to allow page swapping
	var navbuttons = $("#navigation-buttons li a");

	$.each(navbuttons, function(index, value)
	{
		//Cycle through nav buttons and attach event to them, and
		//corresponding pages
		var id = $(value).attr('href');
		var attached_page = $(id);

		//Attach events to nav and page
		$(value).bind('show', function()
		{
			//Find siblings active class and remove
			var atag = $(this).parent().parent().find('a.active');

			atag.trigger('hide');

			if(!$(this).hasClass('active'))
			{
				$(this).addClass('active');
				//add parent class as well
				$(this).parent().addClass('active');
				attached_page.trigger('show');
			}


		});

		$(value).bind('hide', function()
		{
			if($(this).hasClass('active'))
			{
				$(this).removeClass('active');
				//remove parent class as well
				$(this).parent().removeClass('active');
				attached_page.trigger('hide');
			}
		});

		$(attached_page).bind('show', function()
		{
			//Add class active
			if(!$(this).hasClass('active'))
			{
				$(this).removeClass('active').show();
			}
		});

		$(attached_page).bind('hide', function()
		{
			//Remove class active
			if($(this).hasClass('active'))
			{
				$(this).removeClass('active').hide();
			}
		});

		$(attached_page).hide(); //hide all pages
	});
}

function InitCloseButtons($, classname)
{
	var closebuttons = $(classname);

	$.each(closebuttons, function(index, value)
	{
		//Once clicked, remove the current view by grabbing its siblings a tag
		var page_parent = $(value).parent().parent().parent(); //heirarchy

		$(value).click(function(e)
		{
			//Get id name from element page_parent
			var id = page_parent.attr('id');

			//Find nav with same id
			
			var nav = $("#" + id + "-nav");

			if(nav.length > 0)
			{
				//Remove active state
				nav.trigger('hide');
			}	
			else
			{
				//console.log('nothing found :( ');
			}
		});
	});
}

/*function ResizePageWithMaxHeight($, page, width, height, padding)
{
	var padded_width = width - (padding * 2);
	var height = 100
}*/

function ResizePage($, page, width, height, padding)
{
	//Work out padding for width and height
	var padded_width = width - (padding * 2);
	var padded_height = height - (padding * 2);

	if(width != -1)
	{
		$(page).width(padded_width);
	}

	if(height != -1)
	{
		$(page).height(padded_height);
	}
}

function GetWindowWidth($)
{
	return $(window).width();
}

function GetWindowHeight($)
{
	return $(window).height();
}

function GetPageWidth($, page_id)
{
	return $(page_id).width();
}

function GetPageHeight($, page_id)
{
	return $(page_id).height();
}

function FindIndexOfPage($, pagename)
{
	//This function finds which index the element is according to its parent
	var object = $(pagename);
	var index = $(".page").index(object);
	return (index - 1); //subtract one to get true index
}
